import dynamic from "next/dynamic";
import { localhostdomain, WorkDomain } from "@/app/domain";
import { headers } from "next/headers";
import { FetchData } from "@/libs/api";
import { notFound } from "next/navigation";
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
const BlogSchema = dynamic(() => import("@/components/Schema/BlogSchema"));
const BlogHero = dynamic(() => import("@/sections/BlogHero"));
const ContentSec = dynamic(() => import("@/sections/ContentSec"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
export async function generateMetadata({ params }) {
  const { blog_slug } = params;
  const slug = blog_slug;
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const currectUrl = `https://${domain}/blog/${slug}`;
  const parameter = "blog-detail";
  const data = await FetchData(domain, parameter, slug);
  const { meta_title, meta_desc, meta_keywords, blogs } = data;
  return {
    metadataBase: new URL(currectUrl),
    title: meta_title,
    description: meta_desc,
    keywords: meta_keywords,
    alternates: {
      canonical: "/",
    },
    openGraph: {
      url: "/",
      images: {
        url: blogs?.cover_image,
        width: 100,
        height: 100,
      },
    },
  };
}

// Dynamic page for each blog
export default async function PostPage({ params }) {
  const { blog_slug } = params;
  const slug = blog_slug;
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const currectUrl = `https://${domain}/blog/${slug}`;
  const parameter = "blog-detail";
  const data = await FetchData(domain, parameter, slug);
  if (!data?.blogs) {
    notFound();
  }
  const { blogs, meta_keywords, meta_desc, meta_title } = data;
  return (
    <>
      <WebsiteSchema
        title={meta_title}
        description={meta_desc}
        keywords={meta_keywords}
        fullUrl={currectUrl}
      />
      <RatingSchema title={meta_title} />
      <BlogSchema
        title={meta_title}
        img={blogs?.cover_image}
        url={currectUrl}
        blogurl={currectUrl}
      />
      <BlogHero headingBlog={blogs?.page_title} img={blogs?.cover_image} />
      <ContentSec content={blogs?.full_content} date={blogs?.posted_date} />
    </>
  );
}
